/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.core;

import org.hamcrest.AbstractMatcherTest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.CombinableMatcher;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.hamcrest.number.OrderingComparison;
import org.junit.Assert;
import org.junit.Test;

public class CombinableTest {
    private static final CombinableMatcher<Integer> EITHER_3_OR_4 = CombinableMatcher.either((Matcher)IsEqual.equalTo((Object)3)).or(IsEqual.equalTo((Object)4));
    private static final CombinableMatcher<Integer> NOT_3_AND_NOT_4 = CombinableMatcher.both((Matcher)IsNot.not((Matcher)IsEqual.equalTo((Object)3))).and(IsNot.not((Matcher)IsEqual.equalTo((Object)4)));

    @Test
    public void bothAcceptsAndRejects() {
        MatcherAssert.assertThat((Object)2, NOT_3_AND_NOT_4);
        MatcherAssert.assertThat((Object)3, (Matcher)IsNot.not(NOT_3_AND_NOT_4));
    }

    @Test
    public void acceptsAndRejectsThreeAnds() {
        CombinableMatcher tripleAnd = NOT_3_AND_NOT_4.and(IsEqual.equalTo((Object)2));
        MatcherAssert.assertThat((Object)2, (Matcher)tripleAnd);
        MatcherAssert.assertThat((Object)3, (Matcher)IsNot.not((Matcher)tripleAnd));
    }

    @Test
    public void bothDescribesItself() {
        Assert.assertEquals((Object)"(not <3> and not <4>)", (Object)NOT_3_AND_NOT_4.toString());
        AbstractMatcherTest.assertMismatchDescription("not <3> was <3>", NOT_3_AND_NOT_4, 3);
    }

    @Test
    public void eitherAcceptsAndRejects() {
        MatcherAssert.assertThat((Object)3, EITHER_3_OR_4);
        MatcherAssert.assertThat((Object)6, (Matcher)IsNot.not(EITHER_3_OR_4));
    }

    @Test
    public void acceptsAndRejectsThreeOrs() {
        CombinableMatcher orTriple = EITHER_3_OR_4.or(OrderingComparison.greaterThan((Comparable)Integer.valueOf(10)));
        MatcherAssert.assertThat((Object)11, (Matcher)orTriple);
        MatcherAssert.assertThat((Object)9, (Matcher)IsNot.not((Matcher)orTriple));
    }

    @Test
    public void eitherDescribesItself() {
        Assert.assertEquals((Object)"(<3> or <4>)", (Object)EITHER_3_OR_4.toString());
        AbstractMatcherTest.assertMismatchDescription("was <6>", EITHER_3_OR_4, 6);
    }

    @Test
    public void picksUpTypeFromLeftHandSideOfExpression() {
        MatcherAssert.assertThat((Object)"yellow", (Matcher)CombinableMatcher.both((Matcher)IsEqual.equalTo((Object)"yellow")).and(IsNull.notNullValue()));
    }
}

